; single parameter passing using registers
;	char - B
;	int, short - D
;
; more than one parameter, push them all except the last one
;
; parameters are pushed right most first
;

.equ __rs485_recv, 0x800 ; enables rs485 recv mode
.equ __rs485_xmit, 0x803 ; enables rs485 xmit mode
.equ __get_date, 0x806 ; gets date info. from host PC
.equ __get_time, 0x809 ; gets time info. from host PC
.equ __outstrg00, 0x80c ; print a string ended by 0
.equ __lcd_ini, 0x80f ; initializes 16x2 LCD module
.equ __lcd_line1, 0x812 ; displays 16 char on first line
.equ __lcd_line2, 0x815 ; displays 16 char on second line
.equ __sel_inst, 0x818 ; selects instruction before writing LCD module
.equ __sel_data, 0x81b ; selects data before writing LCD module
.equ __wrt_pulse, 0x81e ; generates a write pulse to LCD module
.equ __seven_segment, 0x822 ; convert Accu A to segment pattern, bit 7= DP

	.sect	.text
	.globl	delay1ms
    .globl  lcd_line1, lcd_line2
    .globl  get_date, get_time

; display on line 1 of the LCD
; X - points to the char string
; B - number of char to display
;
lcd_line1:
     tsy       ; get pointer in X
     ldx 2,y
     jmp __lcd_line1
    
; display on line 2 of the LCD
; X - points to the char string
; B - number of char to display
;
lcd_line2:
     tsy       ; get pointer in X
     ldx 2,y
     jmp __lcd_line2

; get 10 char date from host PC
; X - points to buffer
;
get_date:
     xgdx
     jmp __get_date

; get 11 char time from host PC
; X - points to buffer
;
get_time:
     xgdx
     jmp __get_time

.equ oneMs,250

delay1ms:
    pshy
	xgdy
d2:
	pshx
	ldx #oneMs	; 250 x 8 = 2,000 cycles = 1ms
d1:	dex			; 3 cycles
	nop			; 2 cycle
	bne	d1		; 3 cycles
	pulx
	dey		    ; 1 ms loop
	bne	d2
	puly
	rts



; example of reserving data in asm
; variable name in C preceded by '_'
;
	.sect	.data
	.globl __errno
__errno:
	.word 0
	.word 0



